﻿var editModule = {
    context: $(".v-editModule"),
    questionnaireId: 0,
    ProntoNo: 0,
    ProntoModuleType: null,
    Type: null,
    ProjectId: 0,
    moduleName: null,
    initialize: function () {
        editModule.ProjectId = $("#ProjectId").val();

        $(".v-moduleEditorTabs", this.context).a4tabs({
            defaultTab: $("#activeTab", this.context).attr("tab"),
            load: function (e, d) {
                if (d.id == "users") {
                    var usersOrGroups = $("#UsersOrGroups", editModule.context).val();

                    if (usersOrGroups)
                        editModule.selectedUsersAndGroups = _.map(usersOrGroups.split(","), Number);

                    editModule.initializeTreeView(d.tab);
                }
            },
            change: function (e, d) {
                if (d.id == "users") {
                    editModule.userGroupsListView.a4listview("refresh");
                }
            }
        });

        this.toggleAdvancedTab();

        $(".h-questionnaires-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetQuestionnairesForAutoComplete", "Home"),
            valueProperty: "Id",
            labelProperty: "Name",
            categoryProperty: "FolderName",
            altValueField: $("#QuestionnaireId"),
            select: function (event, data) {
                var questionsAutocomplete = $(".h-questionsSelectorAutoComplete", editModule.context);

                if (questionsAutocomplete)
                    questionsAutocomplete.a4autocomplete("clearValue");

                questionsAutocomplete.a4autocomplete({
                    ajaxParams: { questionnaireId: data.item ? data.item.Id : 0, useDefaultQuestionnaire: !data.item, projectId: editModule.ProjectId }
                });
            }
        });

        $("#ExistingSurveyName", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSurveysForAutoComplete", "Home", "Survey"),
            categoryProperty: "Folder",
            valueProperty: "Value",
            labelProperty: "Label",
            altValueField: $("#ExistingSurveyId"),
            select: function (event, data) {
                if (data.item && isNaN(data.item.Value))
                    $("#ExistingSurveyId").val("0");

                $("#CreateNewOrLinkToASurvey", this.context).removeAttr("checked").prop("checked", false);
                $("#CreateNewOrLinkToASurvey[value=Existing]", this.context).attr("checked", "checked").prop("checked", true);
            }
        });

        $(".h-languages-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetLanguagesForAutoComplete", "MultiMode"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#Language", this.context)
        });

        $(".h-webspaces-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetWebSpacesForAutoComplete", "MultiMode", "Settings"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#WebStoreId", this.context),
            required: true
        });

        $(".h-acdModule-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetAcdModulesForAutoComplete", "Modules"),
            ajaxParams: { type: editModule.Type },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#AssociateAcdProjectId", this.context)
        });

        $(".h-acdAssociatedModule-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetAssociatedAcdModulesForAutoComplete", "Modules"),
            ajaxParams: { type: editModule.Type, prontoServerName: function () { return $("#ProntoName").val(); } },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#AssociateAcdProjectId", this.context)
        });

        $(".h-questionsSelectorAutoComplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetVariablesForAutoComplete", "Home"),
            ajaxParams: { questionnaireId: editModule.questionnaireId, useDefaultQuestionnaire: true },
            valueProperty: "Name",
            labelProperty: "Alias",
            altValueField: $("#SearchQuestions", editModule.context),
            multipleSelection: true,
            hideSelectedItems: true,
            displayMultipleSelectionAsList: true
        });

        $(".h-catiProjectName-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetCatiModulesForAutoComplete", "Modules"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#CatiProjectId", this.context),
            validateSelection: true,
            select: function (event, data) {
                var catiProjectId = parseInt(data.item.Id, 10) > 0 ? data.item.Id : "0";
                $("#CatiProjectId", this.context).val(catiProjectId);
                editModule.setUserAndGroupSelection(catiProjectId);
            }
        });

        $(".h-prontoServers-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetProntoServersForAutoComplete", "MultiMode"),
            ajaxParams: { type: editModule.Type },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#ProntoNo", this.context),
            select: function (event, data) {
                var content = $("#LineGroupsEditorContainer", this.context);
                editModule.ProntoNo = data.item === undefined ? "0" : data.item.Id;
                editModule.toggleDnisGridConfig(true);

                $(".h-MonitoringModules-autocomplete", editModule.context).a4autocomplete("clearValue");
                $(".h-MonitoringModules-autocomplete", editModule.context).a4autocomplete({ ajaxParams: { prontoId: editModule.ProntoNo } });

                if (editModule.ProntoModuleType === "ACD") return;

                a4.callServerMethod(a4.getProjectAction("GetLineAssignment", "Modules"), {
                    moduleId: $("#Id", editModule.context).val(),
                    prontoId: editModule.ProntoNo,
                    prontoModuleType: editModule.ProntoModuleType,
                    moduleType: editModule.Type
                },
                function (result) {
                    content.html(result);
                },
                function () {
                    a4.showErrorMessage($(".unexpectedError", this.context).html());
                });
            }
        });

        $(".h-ivrmmServers-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetIvrmmServersForAutoComplete", "MultiMode"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#IvrmmServerNo", this.context)
        });

        $(".h-phoneTemplate-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetPhoneTemplates", "MultiMode", "Settings"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#PhoneTemplateId", this.context)
        });

        $(".h-numberServers-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetNumberServersForAutoComplete", "MultiMode"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#CaseServerNo", this.context)
        });

        $(".h-AdvancedTransferLine-autocomplete", this.context.find(".v-dynamicEditorTable")).a4autocomplete({
            ajaxAction: a4.getAction("GetAdvancedTransferLinesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: { moduleId: $("#ModuleId").val(), prontoId: editModule.ProntoNo },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#AdvancedTransferLine", $(this))
        });

        $(".h-MonitoringModules-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetMonitoringModulesForAutoComplete", "MultiMode"),
            ajaxParams: { prontoId: editModule.ProntoNo },
            valueProperty: "Id",
            labelProperty: "Name",
            multipleSelection: true,
            //displayMultipleSelectionAsList: true,
            altValueField: $("#ProjectsToMonitorJson", this.context)
        });

        editModule.createDnisGrid();
        editModule.toggleDnisGridConfig();

        $(".h-ivrScriptsTransferOnAnsMachineIVRScriptName-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetIvrScriptsForAutoComplete", "MultiMode", null),
            ajaxParams: { prontoId: function () { return $("#ProntoNo", this.context).val(); } },
            valueProperty: "FileName",
            labelProperty: "FileName",
            altValueField: $("#TransferOnAnsMachineIVRScriptName", this.context),
            validateSelection: false
        });

        $(".h-ivrScriptsTransferOnAnsIVRScriptName-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetIvrScriptsForAutoComplete", "MultiMode", null),
            ajaxParams: { prontoId: function () { return $("#ProntoNo", this.context).val(); } },
            valueProperty: "FileName",
            labelProperty: "FileName",
            altValueField: $("#TransferOnAnsIVRScriptName", this.context),
            validateSelection: false
        });

        $(".h-ivrScriptsTransferOnDropIVRScriptName-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetIvrScriptsForAutoComplete", "MultiMode", null),
            ajaxParams: { prontoId: function () { return $("#ProntoNo", this.context).val(); } },
            valueProperty: "FileName",
            labelProperty: "FileName",
            altValueField: $("#TransferOnDropIVRScriptName", this.context),
            validateSelection: false
        });

        if ($("#UseAutomaticCallDisposition", this.context).length > 0)
            editModule.useAutomaticCallDispositionCheck();              
        
        editModule.callProgressAnalysisCheck();
        editModule.advancedCheck();
        editModule.createAdvancedLineAssignmentGrid();
        editModule.toggleDataEntryModeWarning();

        $("#IvrScripts_0__Dnis").attr("readonly", "readonly");
        a4.initializeInputs(this.context);
        a4.setInputFocus(this.context);

        this.bindEvents();
    },
    bindEvents: function () {
        this.context.on("change", "#ProntoNo", function () {
            editModule.toggleAdvancedTab();

            $("#TransferOnAnsIVRScriptName", editModule.context).a4autocomplete("clearValue");
            $("#TransferOnAnsMachineIVRScriptName", editModule.context).a4autocomplete("clearValue");
            $("#TransferOnDropIVRScriptName", editModule.context).a4autocomplete("clearValue");

            editModule.toggleDnisGridConfig(true);
        });

        this.context.on("change", "#ProntoName", function () {
            if ($(this).val() == "") {
                editModule.toggleDnisGridConfig(true);
            }
        });

        this.context.on("click", ".delete-AcdVariable", function () {
            $(this).closest("tr").remove();
            editModule.refreshAcdListBinding();
        });

        this.context.on("click", "#Add-AcdVariable", function () {
            a4.callServerMethod(a4.getProjectAction("AddAcdVariable", "Modules"), {}, function (result) {
                var body = ".h-VariablesJson-dynamicTable table tbody";
                $(body).append(result);
                editModule.refreshAcdListBinding();
            }, null, { dataType: 'html' });
        });

        this.context.on("click", "#UseAutomaticCallDisposition", function () {
            editModule.useAutomaticCallDispositionCheck();
        });

        this.context.on("click", "#CallProgressAnalysis", function () {
            if ($("#ProntoModuleType").val() !== "Predictive")
                editModule.callProgressAnalysisCheck();
        });

        this.context.on("click", "#Advanced_CadenceChecked", function () {
            editModule.toggleCadenceAndDropRateFieldVisibility($(this).val());
        });

        this.context.on("click", "#Advanced", function () {
            editModule.advancedCheck();
        });

        this.context.on("click", ".v-advancedPropertiesCheckbox.disabled", function () {
            // for imitate disabled checkbox
            return false;
        });

        this.context.on("keydown", ".h-questionnaires-autocomplete", function () {
            var questionsAutocomplete = $(".h-questionsSelectorAutoComplete", editModule.context);

            if (questionsAutocomplete)
                questionsAutocomplete.a4autocomplete("clearValue");

            questionsAutocomplete.a4autocomplete({
                ajaxParams: { questionnaireId: 0, useDefaultQuestionnaire: true, projectId: editModule.ProjectId }
            });
        });

        this.context.on("click", "#CreateNewOrLinkToASurvey[value=New]", function () {
            editModule.toggleAcuitySurveySelection("New");
        });

        this.context.on("click", "#CreateNewOrLinkToASurvey[value=Existing]", function () {
            editModule.toggleAcuitySurveySelection("Existing");
        });

        this.context.on("click", "#submit1", function () {
            // remove not used assignment lines
            var isEnabledAdvancedProps = $("#Advanced", this.context).is(':checked');
            var dynamicEditor = $(".v-dynamicEditor", this.context);

            if (dynamicEditor.length > 0)
            {
                $(".v-assignmentRow", dynamicEditor).each(function () {
                    var row = $(this);
                    var doRemoveRow = false;

                    if (isEnabledAdvancedProps)
                        doRemoveRow = ($(".h-advancedTransferLine", row).val().trim() == "" && $(".v-advancedPhonNumber", row).val().trim() == "");
                    else
                        doRemoveRow = ($(".h-advancedTransferLine", row).val().trim() == "" || $(".v-advancedPhonNumber", row).val().trim() == "");

                    if (doRemoveRow) {
                        editModule.replaceItemIndexes(row, dynamicEditor);
                        row.remove();
                    }
                });
            }
        });

        this.context.on("change", "#DataEntryMode", function () {
            editModule.toggleDataEntryModeWarning();
        });
    },
    toggleDataEntryModeWarning: function () {
        var field = $("#DataEntryMode", editModule.context).parents(".field");
        var isChecked = $("#DataEntryMode", editModule.context).is(":checked");
        $(".warning", field).toggle(isChecked);
    },
    refreshAcdListBinding: function () {
        var body = ".h-VariablesJson-dynamicTable table tbody";
        var i = 0;

        $(body + " tr td input").each(function () {
            $(this).attr("id", "VariablesJson_" + i + "__Variable");
            $(this).attr("name", "VariablesJson[" + i + "].Variable");
            i++;
        });
    },
    createAdvancedLineAssignmentGrid: function () {
        var dynamicGridsContainer = $(".v-advancedLinesAssignmentDynamicGridEditorContainer", editModule.context);

        if (dynamicGridsContainer.length > 0) {
            $(".v-dynamicEditor", dynamicGridsContainer).each(function () {
                var editor = $(this);

                editor.on("click", ".h-deleteRow", function () {
                    var item = $(this).closest(".v-editableItem");
                    item.addClass("deleted");
                    item.hide();

                    $(".v-rowState", item).val(2); // deleted

                    editModule.replaceItemIndexes(item, editor);

                    item.remove();
                });

                editor.on("change", ".h-updateRowState", function () {
                    editModule.updateItemRowState($(this));
                });

                editor.on("click", ".v-addRow:not(.disabled)", function () {
                    $('.v-dynamicEditorTable', editor).show();

                    var rowId = $(".v-dynamicTableBody tr", editor).length + 1;
                    var rowPosition = $(".v-dynamicTableBody tr:visible", editor).length + 1;

                    var newItem = $(".v-newItem .v-newItemBody tr", editor).clone();
                    newItem.find(".v-itemIndex").html(rowPosition);
                    newItem.find(".v-rowPosition").val(rowPosition);
                    newItem.removeClass("row0").addClass("row" + rowId);

                    var editorControlName = $(".editorControlName", editor).attr("id");

                    $("input, select", newItem).each(function () {
                        $(this).attr("id", editorControlName + "[" + (rowId - 1) + "]" + $(this).attr("id"));
                        $(this).attr("name", editorControlName + "[" + (rowId - 1) + "]." + $(this).attr("name"));
                    });

                    newItem.find(".h-AdvancedTransferLine-autocomplete").val("");
                    newItem.appendTo($("table .v-dynamicTableBody", editor));
                    $(".h-autonumeric", newItem).autoNumeric();

                    editModule.bindAdvancedTransferLineAutoComplete(newItem);

                    $(".row" + rowId + " input", editor).on("keypress", function (e) { return a4.disableEnter(e); });
                });
            });
        }
    },
    createDnisGrid: function () {
        var dynamicGridsContainer = $(".v-dnisDynamicGridEditorContainer", editModule.context);

        if (dynamicGridsContainer.length > 0) {
            $(".v-dynamicEditor", dynamicGridsContainer).each(function () {
                var editor = $(this);

                editor.on("click", ".h-deleteRow", function () {
                    var item = $(this).closest(".v-editableItem");
                    editModule.replaceItemIndexes(item, editor);
                    item.remove();
                });

                editor.on("change", ".h-updateRowState", function () {
                    editModule.updateItemRowState($(this));
                });

                editor.on("click", ".v-addRow:not(.disabled)", function () {
                    $('.v-dynamicEditorTable', editor).show();

                    var rowId = $(".v-dynamicTableBody tr", editor).length + 1;
                    var rowPosition = $(".v-dynamicTableBody tr:visible", editor).length + 1;
                    var newItem = $(".v-newItems .v-newItemBody tr", editor).clone();

                    newItem.find(".v-itemIndex").html(rowPosition);
                    newItem.find(".v-rowPosition").val(rowPosition);
                    newItem.removeClass("row0").addClass("row" + rowId);

                    var editorControlName = $(".editorControlName", editor).attr("id");

                    $("input, select", newItem).each(function () {
                        $(this).attr("id", editorControlName + "[" + (rowId - 1) + "]" + $(this).attr("id"));
                        $(this).attr("name", editorControlName + "[" + (rowId - 1) + "]." + $(this).attr("name"));
                    });

                    newItem.appendTo($("table .v-dynamicTableBody", editor));

                    var dnisAutoCompleteField = newItem.find(".h-ScriptName-autocomplete");
                    editModule.bindDnisAutoComplete(dnisAutoCompleteField);

                    $(".row" + rowId + " input", editor).on("keypress", function (e) { return a4.disableEnter(e); });

                    $(".h-autonumeric-max999", this.context).autoNumeric({ aPad: false, vMin: '0', vMax: '999', mDec: '0', aSep: '' });

                    var td = $("td", newItem[0])[2];
                    $('input', td).each(function () { $(this).val(""); $(this).text(""); });
                });
            });
        }
    },
    bindAdvancedTransferLineAutoComplete: function (item) {
        var element = item.find(".h-AdvancedTransferLine-autocomplete") || $(".h-AdvancedTransferLine-autocomplete:visible", editModule.context);

        element.a4autocomplete({
            ajaxAction: a4.getAction("GetAdvancedTransferLinesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: { moduleId: $("#ModuleId", editModule.context).val(), prontoId: editModule.ProntoNo },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#AdvancedTransferLine", item)
        });
    },
    bindDnisAutoComplete: function (item) { 
        var element = item ? item : $(".h-ScriptName-autocomplete:visible", editModule.context);
        element.a4autocomplete({
            ajaxAction: a4.getAction("GetIvrScriptsForAutoComplete", "MultiMode", null),
            ajaxParams: { prontoId: function () { return $("#ProntoNo", editModule.context).val(); } },
            valueProperty: "FileName",
            labelProperty: "FileName",
            //altValueField: $("#ScriptName", editModule.context),
            validateSelection: false
        });
    },
    replaceItemIndexes: function (startItem, gridEditor, increaseStartItem) {
        // Replace order if item deleted
        var previousIndex = $(".v-itemIndex", startItem).html();

        startItem.nextAll(".v-editableItem:visible").each(function () {
            var currentRow = $(this);

            $(".v-itemIndex", currentRow).html(previousIndex);
            $(".v-rowPosition", currentRow).val(previousIndex);

            var editorControlName = $(".editorControlName", gridEditor).attr("id");

            $("input, select", currentRow).each(function () {
                var inputName = $(this).attr("name").substr($(this).attr("name").indexOf(".") + 1);

                $(this).attr("id", editorControlName + "_" + (previousIndex - 1) + "__" + inputName);
                $(this).attr("name", editorControlName + "[" + (previousIndex - 1) + "]." + inputName);
            });

            previousIndex++;
        });
    },
    updateItemRowState: function (triggerField) {
        var stateField = $(".v-rowState", triggerField.parents(".v-editableItem"));
        if (stateField.val() == 1)
            stateField.val(3); // updated
    },
    useAutomaticCallDispositionCheck: function () {
        if ($("#UseAutomaticCallDisposition", this.context).is(':checked')) {
            $("#CallProgressAnalysis", this.context).attr("disabled", false).prop("disabled", false);
        } else {
            $("#CallProgressAnalysis", this.context).attr("disabled", true).prop("disabled", true);
            $("#CallProgressAnalysis", this.context).attr("checked", false).prop("checked", false);
        }
        editModule.callProgressAnalysisCheck();
    },
    callProgressAnalysisCheck: function () {
        if ($("#ProntoModuleType").val() === "Predictive") { return; }

        if ($("#CallProgressAnalysis", this.context).is(':checked')) {
            $("#TransferOnAnsIVRScriptName", this.context).attr("disabled", false).prop("disabled", false);
            $("#TransferOnAnsMachineIVRScriptName", this.context).attr("disabled", false).prop("disabled", false);
        } else {
            $("#TransferOnAnsIVRScriptName", this.context).attr("disabled", true).prop("disabled", true);
            $("#TransferOnAnsMachineIVRScriptName", this.context).attr("disabled", true).prop("disabled", true);

            $("#TransferOnAnsIVRScriptName", this.context).val("");
            $("#TransferOnAnsMachineIVRScriptName", this.context).val("");
        }
    },
    toggleAdvancedTab: function () {
        if ($("#ProntoNo").val() > 0)
            $(".v-moduleEditorTabs", this.context).a4tabs('enableTab', 'Advanced');
        else
            $(".v-moduleEditorTabs", this.context).a4tabs('disableTab', 'Advanced');
    },
    toggleCadenceAndDropRateFieldVisibility: function (showManualFields) {
        if (showManualFields.toLowerCase() === "true") {
            $("#Advanced_Cadence", this.context).attr("disabled", false).prop("disabled", false).closest(".section").show();
            $("#Advanced_DesiredDropRate", this.context).attr("disabled", true).prop("disabled", true).closest(".section").hide();
            $("#Advanced_DesiredDropRate", this.context).val(0);
        }
        else {
            $("#Advanced_DesiredDropRate", this.context).attr("disabled", false).prop("disabled", false).closest(".section").show();
            $("#Advanced_Cadence", this.context).attr("disabled", true).prop("disabled", true).closest(".section").hide();
        }
    },
    advancedCheck: function () {
        var isDisabled = !$("#Advanced", this.context).is(':checked');

        $("#UnrestrainedUserDialing", this.context).toggleClass("disabled", isDisabled);
        $("#Conference", this.context).toggleClass("disabled", isDisabled);
        $("#Transfer", this.context).toggleClass("disabled", isDisabled);
        $("#OnHoldSoundFile", this.context).toggleClass("disabled", isDisabled).prop("readonly", isDisabled);

        if (isDisabled) {
            $("#UnrestrainedUserDialing", this.context).attr("checked", false).prop("checked", false);
            $("#Conference", this.context).attr("checked", false).prop("checked", false);
            $("#Transfer", this.context).attr("checked", false).prop("checked", false);
        }

        // Lines Assignment
        $(".v-advancedLinesAssignmentDynamicGridEditorContainer .v-addRow", this.context).toggleClass("disabled", isDisabled).prop("readonly", isDisabled);
        $(".v-advancedLinesAssignmentDynamicGridEditorContainer input[type=text]", this.context).toggleClass("disabled", isDisabled).prop("readonly", isDisabled);
        $(".v-advancedLinesAssignmentDynamicGridEditorContainer .fa-caret-down", this.context).toggle(!isDisabled);
        $(".v-advancedLinesAssignmentDynamicGridEditorContainer .h-deleteRow", this.context).toggle(!isDisabled);
    },
    toggleDnisGridConfig: function (clearScriptNameValue) {
        var isDisabled = editModule.ProntoNo == "0";

        editModule.bindDnisAutoComplete($(".h-ScriptName-autocomplete", editModule.context));

        if (clearScriptNameValue)
            $(".h-ScriptName-autocomplete", editModule.context).a4autocomplete("clearValue");

        $(".v-dnisDynamicGridEditorContainer .h-ScriptName-autocomplete", editModule.context).toggleClass("disabled", isDisabled).prop("readonly", isDisabled);
        $(".v-dnisDynamicGridEditorContainer .v-addRow", editModule.context).toggleClass("disabled", isDisabled).prop("readonly", isDisabled);
    },
    selectedUsersAndGroups: [],
    isGroupActionVisible: function (groupId, users, action) {
        var groupIsSelected = _.some(editModule.selectedUsersAndGroups, function (g) { return g == groupId; });
        var usersAreSelected = !groupIsSelected && _.some(editModule.selectedUsersAndGroups, function (g) { return _.some(users, function (u) { return u.ExternalId == g }); });
        var visible = false;

        if (action == "unchecked")
            visible = !groupIsSelected && !usersAreSelected;
        else if (action == "checked")
            visible = groupIsSelected;
        else if (action == "partial")
            visible = usersAreSelected;

        return visible;
    },
    updateUsersOrGroupsInput: function () {
        $("#UsersOrGroups", editModule.context).val(editModule.selectedUsersAndGroups.join(","));
    },
    setUserAndGroupSelection: function (catiModuleId) {
        var action = a4.getProjectAction("GetCatiUsers", "Modules");

        a4.callServerMethod(action, { moduleId: $("#CatiProjectId").val() }, function (data) {
            editModule.selectedUsersAndGroups = data.ids;
            editModule.updateUsersOrGroupsInput();
        });
    },
    toggleAcuitySurveySelection: function(selectionChoice){
        if (selectionChoice == "Existing") {
            editModule.moduleName = $("#NewSurveyName", this.context).val();
            $("#NewSurveyName", this.context).attr("disabled", true).prop("disabled", true).val('');
            $("#ExistingSurveyName", editModule.context).a4autocomplete("enable");
        }
        else {
            if (editModule.moduleName)
                $("#NewSurveyName", this.context).val(editModule.moduleName);
            $("#NewSurveyName", this.context).attr("disabled", false).prop("disabled", false);
            $("#ExistingSurveyName").val('');
            $("#ExistingSurveyId").val('');
            $("#ExistingSurveyName", editModule.context).a4autocomplete("disable");
        }

    },
    initializeTreeView: function (tab) {
        editModule.userGroupsListView = $(".h-userGroups", tab).a4listview({
            ajaxAction: a4.getAction("GetUserGroups", "Users", "Settings", { multiModeOnly: true }),
            draw: function (event, data) {
                var group = data.selectedNode;
                var groupId = group ? group.Id : null;

                if (editModule.usersDatatable) {
                    editModule.usersDatatable.a4datatable("option", "ajaxParams", { "groupId": groupId });
                    editModule.usersDatatable.a4datatable("option", "selectedRows", editModule.selectedUsersAndGroups);
                    editModule.usersDatatable.a4datatable("refresh", true);
                }
                else {
                    editModule.initializeUsersDataTable(tab, groupId);
                }
            },
            actionButtons: [
                { Action: "select", Label: resources.Select, Icon: "checkbox-unchecked", DisplayCondition: function (data) { return data.ExternalId && voxco.security.has('ADD_USERS_TO_PROJECT') && editModule.isGroupActionVisible(data.ExternalId, data.Users, 'unchecked'); } },
                { Action: "select", Label: resources.Select, Icon: "checkbox-partial", DisplayCondition: function (data) { return data.ExternalId && voxco.security.has('ADD_USERS_TO_PROJECT') && editModule.isGroupActionVisible(data.ExternalId, data.Users, 'partial'); } },
                { Action: "unselect", Label: resources.Unselect, Icon: "checkbox-checked", DisplayCondition: function (data) { return data.ExternalId && voxco.security.has('ADD_USERS_TO_PROJECT') && editModule.isGroupActionVisible(data.ExternalId, data.Users, 'checked');} }
            ],
            actionButtonClick: function (event, data) {
                switch (data.action) {
                    case "select":
                        editModule.selectedUsersAndGroups.push(data.node.ExternalId);
                        break;
                    case "unselect":
                        editModule.selectedUsersAndGroups = _.without(editModule.selectedUsersAndGroups, data.node.ExternalId);
                        break;
                }

                $(this).a4listview("evaluateActionsConditions", data.node.ListView_Internal_Key);

                editModule.updateUsersOrGroupsInput();
            },
            displayActionButtonsOnLeft: true,
            displayActionButtonsOnHover: false,
            icons: null,
            highlightFirstNode: true,
            selectNode: function (event, data) {
                if (!data.selected)
                    return;

                var tableParams = {
                    groupId: data.node ? data.node.Id : null,
                    unassigned: null
                };

                editModule.usersDatatable.a4datatable("option", "ajaxParams", tableParams);
                editModule.usersDatatable.a4datatable("refresh", true);
            },
            localizableTexts: { "Search": resources.SearchUserGroups }
        });
    },
    initializeUsersDataTable: function (tab, groupId) {
        editModule.usersDatatable = $(".h-usersTable", tab).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetUsers", "Users", "Settings"),
            ajaxParams: { "groupId": groupId },
            displayLength: 10,
            allowRowSelection: true,
            displayColumnSelector: false,
            columns: [
                { "Name": "ExternalId", "Visible": false, "Type": "numeric", "Key": true },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName", "Class": "v-name" },
                { "Name": "Firstname", "Title": resources.FirstName, "Data": "Firstname" },
                { "Name": "Lastname", "Title": resources.LastName, "Data": "Lastname" }
            ],
            defaultSorting: "UserName",
            selectedRows: editModule.selectedUsersAndGroups,
            rememberRowSelection: true,
            selectRow: function (e, d) {
                var externalIds = _.pluck(d.data, "ExternalId");

                if (d.isChecked)
                    editModule.selectedUsersAndGroups = _.union(editModule.selectedUsersAndGroups, externalIds);
                else
                    editModule.selectedUsersAndGroups = _.difference(editModule.selectedUsersAndGroups, externalIds);

                editModule.userGroupsListView.a4listview("evaluateActionsConditions");
                editModule.updateUsersOrGroupsInput();
            },
            localizableTexts: { "Search": resources.SearchUsers }
        });
    }
};

$(document).ready(function () {
    if (editModule.context.length > 0) {
        editModule.ProntoNo = $("#ProntoNo", editModule.context).val() == "" ? 0 : $("#ProntoNo", editModule.context).val();
        editModule.ProntoModuleType = $("#ProntoModuleType", editModule.context).val();
        editModule.Type = $("#Type", editModule.context).val();
        editModule.questionnaireId = $("#ProjectQuestionnaireId", editModule.context).val();

        if (!isNaN($("#QuestionnaireId", editModule.context).val()) && $("#QuestionnaireId", editModule.context).val() != 0)
            editModule.questionnaireId = $("#QuestionnaireId", editModule.context).val();

        editModule.initialize();
    }
});